#pragma rtGlobals=1		// Use modern global access method.
#include <Strings as Lists>
#include <Concatenate Waves>

#include "IN2_GeneralProcedures"


function Tube_Model()
	string Rout="500", Rin="350", Len="1e5", volfrac="16", contrast="2.3e21"//, numpts="5000"
	string qstart="0.00001", qstop="0.2"//MatchNist, 
		Prompt Rout, "Tube outer radius [A]"
		Prompt RIn, "Tube inner radius [A]"
		Prompt len, "Tube length [A]"
		Prompt volfrac, "Tube volume fraction (i.e 10%=10)"
		Prompt contrast, "Scattering Contrast [cm^-4]"
		Prompt qstart, "Enter the qmin value for your data range."
		Prompt qstop, "Enter the qmax value for your data range."
		//Prompt numpts, "Number of points in wave"
		//Prompt MatchNist, "Compare to NIST Models?", popup, "Yes;No"
		doprompt "Parameters for tube scatter at High q", rout, rin, len, volfrac, qstart, qstop, contrast//, numpts//MatchNist, 
		
//Making q vector; q in units of [A^-1]
 		variable qmin, qmax, npts=5000
 		qmin=str2num(qstart)
 		qmax=str2num(qstop)
		//npts=5000
		make/o/N=(npts)/O tubeqmodel=qmin+p*(qmax-qmin)/(npts-1)
 
 
 		variable drhosq, router, rinner, length, phi, B1,b2, b3, dradiisq, tubevolume
 		drhosq=str2num(contrast)/1e32//puts the drhosq in units of [A^-4]
 		router=str2num(rout)
 		rinner=str2num(rin)
 		length=str2num(len)
 		phi=str2num(volfrac)/100
 		dradiisq=router^2-rinner^2
 		tubevolume=Pi*dradiisq*length
 
 //Calculating RG and G for tube calculations
 		variable RGtubesq, Gtube
 		RGtubesq=(length^2)/12+(router^2+rinner^2)/2
 		Gtube=phi*drhosq*tubevolume
 		
 //Calculating the B values
 		b1=(2*Pi*Drhosq*phi)*(((2*Pi*dradiisq)+(2*Pi*length*(router+rinner)))/(Pi*length*dradiisq))
 		b2=Pi^2*drhosq*phi*(router-rinner)
 		b3=Gtube*Pi/length
 
 //Calculating crossover points between regions
 		variable xover1, xover2, xover3
 		xover1=1/sqrt(RGtubesq)
 		xover2=1/router
 		xover3=1/(router-rinner)
 		
 //Making the Guinier Region: Converts the units of the intensity to [cm-1]
 		make/o/N=(npts)/O tubeintmodelG=qmin+p*(qmax-qmin)/(npts-1)
 		tubeintmodelG=1e8*Gtube*exp((-1/3)*(tubeintmodelG)^2*RGtubesq)
 
//Making the B/q^1 wave: Converts the units of the intensity to [cm-1]
 		make/o/N=(npts)/O tubeintmodel3=qmin+p*(qmax-qmin)/(npts-1)
 		tubeintmodel3=1e8*b3/(tubeintmodel3)

//Making the B/q^2 wave: Converts the units of the intensity to [cm-1]
 		make/o/N=(npts)/O tubeintmodel2=qmin+p*(qmax-qmin)/(npts-1)
 		tubeintmodel2=1e8*b2/(tubeintmodel2)^2
 
 //Making the B/q^4 wave: Converts the units of the intensity to [cm-1]
 		make/o/N=(npts)/O tubeintmodel=qmin+p*(qmax-qmin)/(npts-1)
 		tubeintmodel=1e8*b1/(tubeintmodel)^4
 					
//Rastering through Region G Intensity to delete overlapping points			
	variable wavept=0
	do	
		if(xover1>tubeqmodel[wavept])
			wavept=wavept+1
		endif
	while (xover1>tubeqmodel[wavept])
	variable ptslevelG=numpnts(tubeintmodelG)

//Rastering through Region -1 Intensity to delete overlapping points			
	variable wavept1=0
	do	
		if(tubeintmodel3[wavept1]<tubeintmodel2[wavept1])
			wavept1=wavept1+1
		endif
	while (tubeintmodel3[wavept1]<tubeintmodel2[wavept1])
	variable ptslevel3=numpnts(tubeintmodel3)
	
//Rastering through Region -4 Intensity to delete overlapping points						
	variable wavept2=0
	do	
		if(tubeintmodel[wavept2]>tubeintmodel2[wavept2])
			wavept2=wavept2+1
		endif
	while (tubeintmodel[wavept2]>tubeintmodel2[wavept2])
	variable ptslevel2=numpnts(tubeintmodel2)
	
//Deleting points--order of deletion does matter--do the last points first [x thru 5000], first points last [0 thru x]
	Deletepoints wavept, ptslevelG, tubeintmodelG
	Deletepoints wavept1, ptslevel3, tubeintmodel3
	Deletepoints 0, wavept, tubeintmodel3
	Deletepoints wavept2, ptslevel2, tubeintmodel2//you must do this deletion first or it screws up the numpnts in wave
	Deletepoints 0, wavept1,  tubeintmodel2
	Deletepoints 0, wavept2,  tubeintmodel

//Combining the waves into 1 CombinedIntensity
	concatenate/o {tubeintmodelG, tubeintmodel3, tubeintmodel2, tubeintmodel}, combinedintensity

//Making a graph of all of the data
		display/k=1 combinedintensity vs tubeqmodel
		ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
		ModifyGraph grid=2,mirror=1,minor(bottom)=1,fStyle=1,fSize=18,logLabel(left)=0
		ModifyGraph font="Helvetica", width=0, height=0, lblMargin(left)=6
		Label left "\\Z18\\f01\\F'Helvetica'Intensity (cm\\S-1\\M\\Z18\\f01)"
		Label bottom "\\Z18\\f01\\F'Helvetica'q (A\\S-1\\M\\Z18\\f01)"
		
end








//Load1dESRFUSAXS() will only reduce the data to (dsigma/domega)*A; need to run ESRF_BKGSUB to get data into absolute units
macro load1dESRFUSAXS(qloadall,nameline,headerlines,nocols,filetype)//,newfolder,nm,)
	variable qloadall=2, nameline=0,headerlines=9,nocols=4//,newfolder=1,nm=1
	variable gthickness=1
	string filetype=".txt"
	Prompt qLoadAll,"Load all data in a Folder?",popup,"User picks waves one at a time"
	//prompt gthickness,"Sample Thickness (cm)"
	Prompt nameline,"Line containg sample name"
	Prompt headerlines,"Number of Lines in Header"
	prompt nocols,"Number of Columns of Data"
	prompt filetype, "Extension or mac file type"
	//doprompt "Input Panel", qloadall,nm,newfolder,nameline,headerlines,nocols,filetype
	silent 1	
	variable index=0,Counter,length, refno,len,endname, answer
	String LineOfNote,HeaderText,name,rwave,swave,qwave,samplename="",fullpath
	string/g root:p:gfilename
	string/g root:filename=root:p:gfilename
	string/g root:p:gpath
	string/g root:path=root:p:gpath

		
		Open/R/T=filetype/m=filetype refno as root:p:gfilename
		getfilename(s_filename)
		fullpath=s_filename
		NewPath/O temporarypath root:p:gpath
		
	string/g filename=s_filename
			if (strlen(filename)==0)
						Killvariables/a/z;killstrings/a/z
						//break  //always exit here
						abort"You must choose a .txt file"
					endif
				Open /R/T=filetype/P=temporarypath refno as filename
				getfilename(s_filename)
				fullpath=s_filename

//Copying the Header into a string
		setdatafolder root:P:
		string/g transm, wvlgth
		string/g root:p:cutofftransm, root:p:cutoffwvlgth
		variable/g root:p:gtransmission, root:p:gwavelength
		
		counter=0
		HeaderText=root:filename+"\r\r"
		If(!headerlines==0)
			do
				FReadLine refNo, LineOfNote
				HeaderText+=LineOfNote
					if (counter ==nameline)//picks sample name out of this line
						length =strlen(lineofnote)
						samplename=lineOfNote[7, (length-2)]				
					endif
					
					if(stringmatch(lineofnote, "Transmission*"))
						transm=lineofnote
						cutofftransm=transm[15,21]
						gtransmission=str2num(cutofftransm)
						killstrings/z cutofftransm, transm
					endif	
					
					if(stringmatch(lineofnote, "Wavelength*"))
						wvlgth=lineofnote
						cutoffwvlgth=wvlgth[23,30]
						gwavelength=str2num(cutoffwvlgth)
						killstrings/z cutoffwvlgth, wvlgth
					endif	
					
					Counter+=1
			while(Counter<headerlines)  //last line of header
		endif
		close refno
//End of header file copy
		
//Cleaning up file names and making the folders
		name=root:p:gfilename
		string/g root:p:shortname
		shortname=ListMatch(name, "bh*",":")
		name=shortname
		len=-1+strlen(name)
		endname=len-strlen(filetype)//takes off ".txt" extension
		name=name[0,endname]
		name=cleanupName(name,0)
		name=Getnamechanges(name)
		string foldername=name[0,30]
		setdatafolder root:
			if (!DataFolderExists("root:ESRF"))		
					NewDataFolder/O root:ESRF
			endif
		setdatafolder root:ESRF
		NewDataFolder/O/S $foldername		
//End of naming and folder creation
		killstrings/z root:filename,root:path, root:p:gfilename, root:p:gpath, root:P:gpath, root:p:gfullpath,root:p:shortname
		
//Loading the columns of data into waves: Col1 = qvector, Col4 = Intensity
		LoadWave/q/a/D/g/L={0,counter,200,0,nocols} fullpath
		rwave="r_"+name
		swave="s_"+name
		qwave="q_"+name
		//making raw waves
		duplicate/o wave3,$rwave
		duplicate/o wave0,$qwave
		duplicate/o wave1, $swave
		variable/g transmission, wavelength, CapOmega=6.85e-10
		transmission=root:p:gtransmission
		wavelength=root:p:gwavelength
		//thickness=gthickness

//Reducing the waves via Narayan/Schaefer/Justice Method: Data not in absolue units(dsigma/domege)*(1/A)
		duplicate/o wave3,INT_wav
		duplicate/o wave0,QVEC_wav
		duplicate/o wave1, ERR_wav//this is not a true error wave
		qvec_wav=((4*pi)/wavelength)*sin((10^(qvec_wav)*1e-6)/2)
		duplicate/o qvec_wav, $qwave+"_cor"
		int_wav=int_wav/(transmission*CapOmega)//intensity is now absolut
		duplicate/o int_wav, $rwave+"_cor"
		err_wav=err_wav/(transmission*CapOmega)//this is not a true error wave
		duplicate/o err_wav, $swave+"_cor"
//End of Reduction--data not in absolute units yet		
		
		killwaves/z wave0, wave1, wave2, wave3, qvec_wav, int_wav, err_wav
		killvariables/z root:p:gtransmission, root:p:gwavelength, capomega
		Note $qwave, HeaderText
		Note $rwave, HeaderText
		Note $swave, HeaderText
		string/g basename=s_filename
		string/g path=s_path
//End of data correction		
		
//Making a graph of all of the data
			display/k=1 $rwave+"_cor" vs $qwave+"_cor"
			//dowindow/r/k "Data Analysis"
			TextBox/C/N=text0/A=MC name
			ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
			ModifyGraph grid=2,mirror=1,minor(bottom)=1,fStyle=1,fSize=18,logLabel(left)=0
			ModifyGraph font="Helvetica", width=234, height=288, lblMargin(left)=6
			Label left "\\Z18\\f01\\F'Helvetica'Intensity (cm\\S-1\\M\\Z18\\f01)"
			Label bottom "\\Z18\\f01\\F'Helvetica'q (A\\S-1\\M\\Z18\\f01)"
//Graphing complete
		
//Keep cycling throught the data
	do
		//continueanalysis()
		answer=continueanalysis()
	
	while (answer==1)
//Finished analyzing data
end

//Allows load1desrfusaxs to load multiple samples
function ContinueAnalysis()
	variable question
	prompt question, "Would you like to analyze another sample?", Popup, "Yes?;No?"
	doprompt "CONTINUE ANALYSIS", question
		if(question==1)
		string goback
		sprintf goback, "load1dESRFUSAXS(qloadall,nameline,headerlines,nocols,filetype)"
		execute goback
		else
		abort
	endif
	return question
	end
	
//Complementary function to load1desrfusaxs: ESRF_BKGSUB will put the data in (dsigma/domega)*(1/V)
function ESRF_BKGSUB()//samplefolder, bkgfolder, abbrev)
	string/g  root:P:ScantypeY, root:P:ScantypeX
	SVAR SY=root:P:ScantypeY
	string samplefolder, bkgfolder, abbrev="", folderlist, qrs
	variable len, namelength
	string samplethickness="1"
	folderlist=FindQRSfolders()
	doalert 0, "Make sure your data have been reduced/corrected before continuing"
	Prompt samplefolder, "Pick the sample you want to background subtract", popup, folderlist
	Prompt samplethickness, "Enter the sample thickness [cm]."
	Prompt bkgfolder, "Pick an background file", popup, folderlist
	Prompt abbrev, "Type a short (3-5 characters) abbreviation for the bkg"
	doprompt "Choose Data for Background Subtraction", samplefolder, samplethickness, bkgfolder, abbrev

//Kills the program if no abbreviation is present.  Abbrev. is essential to naming structure in the folders	
	string zero=""
	variable abbrevpresent
	abbrevpresent=cmpstr(abbrev, zero)
	
		if(abbrevpresent==0)
			abort"You must enter an abbreviation to continue.\r(e.g. Airblank5=ab5, etc.)"
		endif
		
//Preparations for new waves	
	string initsamplename, samplename, sampleidqwave, sampleidrwave, sampleidswave, colon=":"
	string initbkgname, bkgname, bkgidqwave, bkgidrwave, bkgidswave

	initsamplename=ListMatch(samplefolder, "bh*",":")
	len=-1+strlen(initsamplename)
	namelength=len-strlen(colon)//takes off ":"
	samplename=initsamplename[0,namelength]
	sampleidqwave="q_"+samplename+"_cor"
	sampleidrwave="r_"+samplename+"_cor"
	sampleidswave="s_"+samplename+"_cor"
	
	initbkgname=ListMatch(bkgfolder, "bh*",":")
	len=-1+strlen(initbkgname)
	namelength=len-strlen(colon)//takes off ":"
	bkgname=initbkgname[0,namelength]
	bkgidqwave="q_"+bkgname+"_cor"
	bkgidrwave="r_"+bkgname+"_cor"
	bkgidswave="s_"+bkgname+"_cor"
	
//Setting up new waves that will contain the subtracted data
		setdatafolder samplefolder
		if(waveexists($sampleidqwave))
			duplicate/o $sampleidqwave, qwavechk
			string newqname="q_"+samplename+"_cor"+abbrev
		endif
		
		if(waveexists($sampleidrwave))
			duplicate/o $sampleidrwave, rwavechk
			string newrname="r_"+samplename+"_cor"+abbrev
		endif
		
		if(waveexists($sampleidswave))
			duplicate/o $sampleidswave, swavechk
			string newsname="s_"+samplename+"_cor"+abbrev
		endif
//3 new waves in the sample folder: extension _cor_$abbrev

//Doing the subtraction of and correction for thickness
	setdatafolder $bkgfolder
	MoveWave $bkgidqwave, $samplefolder
	MoveWave $bkgidrwave, $samplefolder
	MoveWave $bkgidswave, $samplefolder
		
	setdatafolder $samplefolder	
		duplicate/o $bkgidqwave, bkgqwave
		duplicate/o $bkgidrwave, bkgrwave
		duplicate/o $bkgidswave, bkgswave

//Putting the data in abs units (dsigma/domega)*(1/V)
	variable/g thickness=str2num(samplethickness)
	rwavechk=(rwavechk-bkgrwave)/(thickness)
	swavechk=(swavechk-bkgswave)/(thickness)
	
	rename qwavechk, $newqname
	duplicate/o $newqname, $newqname+"_t"
	rename rwavechk, $newrname+"_t"
	rename swavechk, $newsname+"_t"

	killwaves/z bkgqwave, bkgrwave, bkgswave, $newqname

//Putting the bkg data back where it belongs	
	setdatafolder $samplefolder
	MoveWave $bkgidqwave, $bkgfolder	
	MoveWave $bkgidrwave, $bkgfolder	
	MoveWave $bkgidswave, $bkgfolder	

end